
clear all

foreach variable in LFPR_Fem_ILO Ad_Fert_R F_M_LFPR_RATIO GII Mat_Mort_R_MO Prim_Enr_GPI Sec_Enr_GPI Tert_Enr_GPI {

local file "All_pvals_`variable'22allyrs_Final" // make sure incomplete is **NOT*** commented out
*local file "All_pvals_Ad_Fert_R22allyrs_Final" // make sure incomplete is **NOT*** commented out
*local file "All_pvals_F_M_LFPR_RATIO22allyrs_Final" // make sure incomplete is **NOT*** commented out
*local file "All_pvals_GII22allyrs_Final" // make sure incomplete is **NOT*** commented out
*local file "All_pvals_Mat_Mort_R_MO22allyrs_Final" // make sure incomplete is **NOT*** commented out
*local file "All_pvals_Prim_Enr_GPI22allyrs_Final" // no incomplete comment out
*local file "All_pvals_Sec_Enr_GPI22allyrs_Final" // no incomplete comment out
*local file "All_pvals_Tert_Enr_GPI22allyrs_Final" // no incomplete comment out

/////////////////////////////
///// complete programs first
/////////////////////////////

use "R:\Reina\Replication_Gender_July13\IMFWP_ResCover/`file'.dta" , clear

display "Running for `variable'"
drop _merge
drop if unique_W == 0
drop if gap ==.

gen programx = .
order countrycode year programx

replace programx = -4 if _n == 1 | ( _n >= 1 & mod(_n - 1, 9) == 0 )
replace programx = -3 if _n == 2 | ( _n >= 2 & mod(_n - 2, 9) == 0 )
replace programx = -2 if _n == 3 | ( _n >= 3 & mod(_n - 3, 9) == 0 )
replace programx = -1 if _n == 4 | ( _n >= 4 & mod(_n - 4, 9) == 0 )
replace programx = 0 if _n == 5 | ( _n >= 5 & mod(_n - 5, 9) == 0 )
replace programx = 1 if _n == 6 | ( _n >= 6 & mod(_n - 6, 9) == 0 )
replace programx = 2 if _n == 7 | ( _n >= 7 & mod(_n - 7, 9) == 0 )
replace programx = 3 if _n == 8 | ( _n >= 8 & mod(_n - 8, 9) == 0 )
replace programx = 4 if _n == 9 | ( _n >= 9 & mod(_n - 9, 9) == 0 )

order countrycode year programx _Y_treated _Y_synthetic

gen Y_treat_base = _Y_treated if programx == -1
replace Y_treat_base = Y_treat_base[_n-1] if programx == 0
replace Y_treat_base = Y_treat_base[_n+1] if programx == -2
replace Y_treat_base = Y_treat_base[_n+2] if programx == -3
replace Y_treat_base = Y_treat_base[_n+3] if programx == -4
replace Y_treat_base = Y_treat_base[_n-2] if programx == 1
replace Y_treat_base = Y_treat_base[_n-3] if programx == 2
replace Y_treat_base = Y_treat_base[_n-4] if programx == 3
replace Y_treat_base = Y_treat_base[_n-5] if programx == 4

gen gap_norm = gap/Y_treat_base

order countrycode year programx _Y_treated Y_treat_base gap_norm

gen long counter = _n

order counter countrycode year programx _Y_treated Y_treat_base gap_norm

order counter countrycode year programx gap_norm p _Y_treated Y_treat_base gap_norm
sort counter

order counter countrycode year programx gap_norm p _Y_treated Y_treat_base gap_norm
keep counter countrycode year programx gap_norm p _Y_treated Y_treat_base gap_norm

format p %12.0g
gen str10 star = ""
replace star = "***" if p < 0.01
replace star = "**"  if p <= 0.05 & p > 0.01
replace star = "*"  if p <= 0.1 & p > 0.05

gen double gapnormpct = round(gap_norm * 100, 0.01)
tostring gapnormpct, gen(gapnormpct_str) force
*gen str gappct_sig = gapnormpct_str + "_" + star
gen str gappct_sig = gapnormpct_str + star

gen progyr = year if programx == 0
replace progyr = progyr[_n+1] if programx == -1
replace progyr = progyr[_n+2] if programx == -2
replace progyr = progyr[_n+3] if programx == -3
replace progyr = progyr[_n+4] if programx == -4
replace progyr = progyr[_n-1] if programx == 1
replace progyr = progyr[_n-2] if programx == 2
replace progyr = progyr[_n-3] if programx == 3
replace progyr = progyr[_n-4] if programx == 4

order counter countrycode year progyr programx gap_norm p _Y_treated Y_treat_base gap_norm

keep countrycode progyr programx gappct_sig

tostring progyr, gen(progyr_str) force
tostring countrycode, gen(countrycode_str) force

gen str country_year = countrycode_str + "_" + progyr_str

keep country_year programx gappct_sig

save toreshape, replace
use toreshape, clear

*reshape wide age, i(famid)  j(birth)  
*replace country_year = subinstr(country_year, " ", "&", .)
*replace gappct_sig = subinstr(gappct_sig, "_", "&", .)
*replace country_year = subinstr(country_year, "_", "&", .)

tostring programx, gen(programx_str) force
replace programx_str = subinstr(programx_str, "-", "m", .)

ren gappct_sig gappctsig
ren country_year countryyear
ren programx_str program
drop programx
reshape wide gappctsig, i(countryyear) j(program) string

*reshape wide gappct_sig, i(country_year) j(programx_for_j) 

order countryyear	gappctsigm4	gappctsigm3	gappctsigm2	gappctsigm1	gappctsig0	gappctsig1	gappctsig2	gappctsig3	gappctsig4

split countryyear, parse("_")
rename countryyear1 country
rename countryyear2 progyr
drop countryyear
order country progyr	gappctsigm4	gappctsigm3	gappctsigm2	gappctsigm1	gappctsig0	gappctsig1	gappctsig2	gappctsig3	gappctsig4

////////
ren country countrycode
sort countrycode
destring countrycode, replace
*merge m:1 countrycode using countryname_mapping.dta
*drop if _merge==2
kountry countrycode, from(imfn) m
drop MARKER
rename NAMES_STD countryname

destring progyr, replace force
rename progyr year
merge m:m countrycode year using Facility_append.dta
drop if _m==2

duplicates list year countryname


egen group_id = group(year countryname)

* Step 2: Create a new variable to hold the combined Facility string
gen Facility_combined = ""

* Step 3: Get list of unique group IDs
levelsof group_id, local(groups)

* Step 4: Loop through each group and concatenate Facility values
foreach g of local groups {
    * Get unique Facility values in this group (subset by if)
    levelsof Facility if group_id == `g', local(facs)

    * Concatenate with slashes
    local combined ""
    foreach f of local facs {
        if "`combined'" == "" {
            local combined "`f'"
        }
        else {
            local combined "`combined'/`f'"
        }
    }

    * Assign combined string to Facility_combined in all rows of this group
    replace Facility_combined = "`combined'" if group_id == `g'
}

* Step 5: Keep only one row per group
bysort group_id (year): keep if _n == 1

* Step 6: Replace Facility with the combined version
replace Facility = Facility_combined

* Step 7: Cleanup
drop Facility_combined group_id

sort year countryname

rename year progyr
order countryname progyr	gappctsigm4	gappctsigm3	gappctsigm2	gappctsigm1	gappctsig0	gappctsig1	gappctsig2	gappctsig3	gappctsig4 Facility
keep countryname progyr	gappctsigm4	gappctsigm3	gappctsigm2	gappctsigm1	gappctsig0	gappctsig1	gappctsig2	gappctsig3	gappctsig4 Facility

sort progyr countryname
replace countryname = strproper(countryname)

gen classification = "Nonsignificant"

foreach var in gappctsig4 gappctsig3 gappctsig2 gappctsig1 gappctsig0 {
    replace classification = "Significantly Positive" if strpos(`var', "*") & real(substr(`var', 1, strpos(`var', "*") - 1)) > 0 & classification == "Nonsignificant"
    replace classification = "Significantly Negative" if strpos(`var', "*") & real(substr(`var', 1, strpos(`var', "*") - 1)) < 0 & classification == "Nonsignificant"
}

tab classification

    if inlist("`variable'", "Prim_Enr_GPI", "Sec_Enr_GPI", "Tert_Enr_GPI") {
destring gappctsigm1, replace force
drop if gappctsigm1>10
drop if gappctsigm1<-10

*tostring gappctsig4, replace force

ren gappctsigm4 minus4
ren gappctsigm3 minus3
ren gappctsigm2 minus2
ren gappctsigm1 minus1
ren gappctsig0 Prog
ren gappctsig1 plus1
ren gappctsig2 plus2
ren gappctsig3 plus3
ren gappctsig4 plus4

save "R:\Reina\Replication_Gender_July13\Appendix Table Results/`file'complete.dta", replace

continue  // skip rest of loop for this variable
    }

/////////////////////////////////
* */ comment out for ed data
////////////////////////////////

///////////////////////////////////////////
///// ***IN***complete programs post 2016 second
///////////////////////////////////////////


*use "C:/Users/te/OneDrive - UW/Monique gender/submission European Journal of Political Economy/revison/Replication_Gender_Feb20/IMFWP_ResCover_Additional/All_pvals_LFPR_Fem_ILO22allyrs_Final.dta" , clear
use "R:\Reina\Replication_Gender_July13\IMFWP_ResCover_Additional/`file'.dta" , clear
drop if unique_W == 0
drop if gap ==.

/// deal with missing years
* tsset panelvar timevar
tsset countrycode year
// this does not work for the main file since there are overlapping country/years
*sort countrycode year
*duplicates report countrycode year

sort countrycode year

bysort countrycode (year): gen programx = _n
order programx
replace programx = -4 if programx == 1
replace programx = -3 if programx == 2
replace programx = -2 if programx == 3
replace programx = -1 if programx == 4
replace programx = 0 if programx == 5
replace programx = 1 if programx == 6
replace programx = 2 if programx == 7
replace programx = 3 if programx == 8
replace programx = 4 if programx == 9

order countrycode year programx _Y_treated _Y_synthetic


gen Y_treat_base = _Y_treated if programx == -1
replace Y_treat_base = Y_treat_base[_n-1] if programx == 0
replace Y_treat_base = Y_treat_base[_n+1] if programx == -2
replace Y_treat_base = Y_treat_base[_n+2] if programx == -3
replace Y_treat_base = Y_treat_base[_n+3] if programx == -4
replace Y_treat_base = Y_treat_base[_n-2] if programx == 1
replace Y_treat_base = Y_treat_base[_n-3] if programx == 2
replace Y_treat_base = Y_treat_base[_n-4] if programx == 3
replace Y_treat_base = Y_treat_base[_n-5] if programx == 4

gen gap_norm = gap/Y_treat_base

order countrycode year programx _Y_treated Y_treat_base gap_norm

gen long counter = _n

order counter countrycode year programx _Y_treated Y_treat_base gap_norm

order counter countrycode year programx gap_norm p _Y_treated Y_treat_base gap_norm
sort counter

order counter countrycode year programx gap_norm p _Y_treated Y_treat_base gap_norm
keep counter countrycode year programx gap_norm p _Y_treated Y_treat_base gap_norm

format p %12.0g

gen str10 star = ""
replace star = "***" if p < 0.01
replace star = "**"  if p <= 0.05 & p > 0.01
replace star = "*"  if p <= 0.1 & p > 0.05

gen double gapnormpct = round(gap_norm * 100, 0.01)
tostring gapnormpct, gen(gapnormpct_str) force
*gen str gappct_sig = gapnormpct_str + "_" + star
gen str gappct_sig = gapnormpct_str + star

gen progyr = year if programx == 0
replace progyr = progyr[_n+1] if programx == -1
replace progyr = progyr[_n+2] if programx == -2
replace progyr = progyr[_n+3] if programx == -3
replace progyr = progyr[_n+4] if programx == -4
replace progyr = progyr[_n-1] if programx == 1
replace progyr = progyr[_n-2] if programx == 2
replace progyr = progyr[_n-3] if programx == 3
replace progyr = progyr[_n-4] if programx == 4

order counter countrycode year progyr programx gap_norm p _Y_treated Y_treat_base gap_norm

keep countrycode progyr programx gappct_sig

tostring progyr, gen(progyr_str) force
tostring countrycode, gen(countrycode_str) force

gen str country_year = countrycode_str + "_" + progyr_str

keep country_year programx gappct_sig

save toreshape, replace
use toreshape, clear

*reshape wide age, i(famid)  j(birth)  
*replace country_year = subinstr(country_year, " ", "&", .)
*replace gappct_sig = subinstr(gappct_sig, "_", "&", .)
*replace country_year = subinstr(country_year, "_", "&", .)

tostring programx, gen(programx_str) force
replace programx_str = subinstr(programx_str, "-", "m", .)

ren gappct_sig gappctsig
ren country_year countryyear
ren programx_str program
drop programx
reshape wide gappctsig, i(countryyear) j(program) string

*reshape wide gappct_sig, i(country_year) j(programx_for_j) 

order countryyear	gappctsigm4	gappctsigm3	gappctsigm2	gappctsigm1	gappctsig0	gappctsig1	gappctsig2	gappctsig3	

split countryyear, parse("_")
rename countryyear1 country
rename countryyear2 progyr
drop countryyear
order country progyr	gappctsigm4	gappctsigm3	gappctsigm2	gappctsigm1	gappctsig0	gappctsig1	gappctsig2	gappctsig3	

////////
ren country countrycode
sort countrycode
destring countrycode, replace
kountry countrycode, from(imfn) m
drop MARKER
rename NAMES_STD countryname

destring progyr, replace force
rename progyr year
merge m:m countrycode year using Facility_append.dta
drop if _m==2

duplicates list year countryname


egen group_id = group(year countryname)

* Step 2: Create a new variable to hold the combined Facility string
gen Facility_combined = ""

* Step 3: Get list of unique group IDs
levelsof group_id, local(groups)

* Step 4: Loop through each group and concatenate Facility values
foreach g of local groups {
    * Get unique Facility values in this group (subset by if)
    levelsof Facility if group_id == `g', local(facs)

    * Concatenate with slashes
    local combined ""
    foreach f of local facs {
        if "`combined'" == "" {
            local combined "`f'"
        }
        else {
            local combined "`combined'/`f'"
        }
    }

    * Assign combined string to Facility_combined in all rows of this group
    replace Facility_combined = "`combined'" if group_id == `g'
}

* Step 5: Keep only one row per group
bysort group_id (year): keep if _n == 1

* Step 6: Replace Facility with the combined version
replace Facility = Facility_combined

* Step 7: Cleanup
drop Facility_combined group_id

sort year countryname
rename year progyr

order countryname progyr	gappctsigm4	gappctsigm3	gappctsigm2	gappctsigm1	gappctsig0	gappctsig1	gappctsig2	gappctsig3	 Facility
keep countryname progyr	gappctsigm4	gappctsigm3	gappctsigm2	gappctsigm1	gappctsig0	gappctsig1	gappctsig2	gappctsig3	 Facility	

sort progyr countryname
replace countryname = strproper(countryname)


save "R:\Reina\Replication_Gender_July13\Appendix Table Results/`file'INcomplete.dta", replace

use "R:\Reina\Replication_Gender_July13\Appendix Table Results/`file'complete.dta", clear

append using "R:\Reina\Replication_Gender_July13\Appendix Table Results/`file'INcomplete.dta"


 
ren gappctsigm4 minus4
ren gappctsigm3 minus3
ren gappctsigm2 minus2
ren gappctsigm1 minus1
ren gappctsig0 Prog
ren gappctsig1 plus1
ren gappctsig2 plus2
ren gappctsig3 plus3
ren gappctsig4 plus4


replace classification = "Nonsignificant" if classification == ""

foreach var in plus4 plus3 plus2 plus1 Prog {
    replace classification = "Significantly Positive" if strpos(`var', "*") & real(substr(`var', 1, strpos(`var', "*") - 1)) > 0 & classification == "Nonsignificant"
    replace classification = "Significantly Negative" if strpos(`var', "*") & real(substr(`var', 1, strpos(`var', "*") - 1)) < 0 & classification == "Nonsignificant"
}

destring minus1, replace force
drop if minus1>10
drop if minus1<-10

tab classification
drop countrycode 
save "R:\Reina\Replication_Gender_July13\Appendix Table Results/`file'ALLcomplete.dta", replace

export excel countryname progyr minus4 minus3 minus2 minus1 Prog plus1 plus2 plus2 plus4 using "R:\Reina\Replication_Gender_July13\Appendix Table Results`file'ALLcomplete.xlsx", firstrow(variables) replace

}